/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Properties;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class AppSharedSecretDecryptionTest {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            AppSharedSecretDecryptionTest.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            AppSharedSecretDecryptionTest.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            AppSharedSecretDecryptionTest.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            AppSharedSecretDecryptionTest.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        AppSharedSecretDecryptionTest.codes[43] = 62;
        AppSharedSecretDecryptionTest.codes[47] = 63;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        int ix = 0;
        while (ix < data.length) {
            if (data[ix] > '\u00ff' || codes[data[ix]] < 0) {
                --tempLen;
            }
            ++ix;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix2 = 0;
        while (ix2 < data.length) {
            int value;
            int n = value = data[ix2] > '\u00ff' ? -1 : codes[data[ix2]];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix2;
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    public static byte[] decode(String base64EncodedString) {
        if (base64EncodedString == null) {
            return null;
        }
        return AppSharedSecretDecryptionTest.decode(base64EncodedString.toCharArray());
    }

    public static void decryptSecret(String encryptedSharedSecret, String keyStorePath, String keyStoreAlias, String keyStorePass, String keyStoreType) {
        try {
            byte[] encryptedSharedSecretBytes = Base64.decodeBase64(encryptedSharedSecret.getBytes("UTF-8"));
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                ks.load(fis, keyStorePass.toCharArray());
            }
            PrivateKey pvtkey = (PrivateKey)ks.getKey(keyStoreAlias, keyStorePass.toCharArray());
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, pvtkey);
            byte[] sharedSecret = cipher.doFinal(encryptedSharedSecretBytes);
            System.out.println("Shared Secret = " + new String(sharedSecret));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            File file;
            Properties properties = new Properties();
            if (args.length == 0) {
                System.out.println("Usage: java -jar AppSharedSecretDecryptionTest.jar c:\\temp\\project.properties");
                return;
            }
            String propertFilePath = args[0];
            if (!propertFilePath.endsWith("project.properties")) {
                propertFilePath = propertFilePath.endsWith("\\") ? String.valueOf(propertFilePath) + "project.properties" : String.valueOf(propertFilePath) + "\\project.properties";
            }
            if (!(file = new File(propertFilePath)).exists()) {
                System.out.println("project.properties file is missing in the path provided. Please include it and run this project");
                return;
            }
            FileInputStream inStream = new FileInputStream(file);
            properties.load(inStream);
            String encryptedSharedSecret = properties.getProperty("encrypted_shared_secret");
            String keyStorePath = properties.getProperty("keystore_path_filename");
            String keyStoreAlias = properties.getProperty("keystore_alias");
            String keyStorePass = properties.getProperty("keystore_pass");
            if (encryptedSharedSecret == null || keyStorePath == null || keyStoreAlias == null || keyStorePass == null) {
                System.out.println("Required information in the project.properties file is missing. See the sample properties file in the jar.");
                return;
            }
            String keyStoreType = properties.getProperty("keystore_type");
            if (keyStoreType == null || keyStoreType.isEmpty()) {
                System.out.println("keystore_type property is missing in project.properties file. Setting the type to PKCS12");
                keyStoreType = "PKCS12";
            }
            AppSharedSecretDecryptionTest.decryptSecret(encryptedSharedSecret, keyStorePath, keyStoreAlias, keyStorePass, keyStoreType);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

